Attribute VB_Name = "Module1"
Option Explicit

'Api's type's constants and globals
Private Declare Function GetWindowDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetDesktopWindow Lib "user32" () As Long
Private Declare Function GetWindow Lib "user32" (ByVal hwnd As Long, ByVal wCmd As Long) As Long
Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function CreateDIBSection Lib "gdi32" (ByVal hdc As Long, pBitmapInfo As BITMAPINFO, ByVal un As Long, ByVal lplpVoid As Long, ByVal handle As Long, ByVal dw As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function GetBitmapBits Lib "gdi32" (ByVal hBitmap As Long, ByVal dwCount As Long, lpBits As Any) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long

Private Type BITMAPINFOHEADER '40 bytes
        biSize As Long
        biWidth As Long
        biHeight As Long
        biPlanes As Integer
        biBitCount As Integer
        biCompression As Long
        biSizeImage As Long
        biXPelsPerMeter As Long
        biYPelsPerMeter As Long
        biClrUsed As Long
        biClrImportant As Long
End Type
Private Type RGBQUAD
        rgbBlue As Byte
        rgbGreen As Byte
        rgbRed As Byte
        rgbReserved As Byte
End Type
Private Type BITMAPINFO
        bmiHeader As BITMAPINFOHEADER
        bmiColors As RGBQUAD
End Type
Private Const BI_RGB = 0&
Private Const DIB_RGB_COLORS = 0 ' color table in RGBs

Dim bBytes() As Byte
 
Sub main()
    Dim objApp As MapPoint.Application
    Dim objmap As MapPoint.Map
    Dim objLoc As MapPoint.Location
    Dim intCount As Integer
    
    'set a reference to Mappoint and the active map.
    'For this code to work there has to be an active route in Mappoint
    Set objApp = GetObject(, "MapPoint.Application")
    Set objmap = objApp.ActiveMap
    'loop through all the route segments
    For intCount = 1 To objmap.ActiveRoute.Directions.Count
        'get te location of the start of the route segment
        Set objLoc = GetRouteSegmentStartLocation(objmap, intCount)
        'if the location is found, add a pushpin at the location
        If Not objLoc Is Nothing Then
            objmap.AddPushpin objLoc, intCount
        End If
    Next
    Set objApp = Nothing
End Sub

Function GetRouteSegmentStartLocation(objmap As MapPoint.Map, intSegment As Integer) As MapPoint.Location
    Dim lngHwnd As Long
    Dim lngDC As Long
    Dim lngWidth As Long
    Dim lngHeight As Long
    Dim blfound As Boolean
    Dim intGrid As Integer
    Dim intGridCount As Integer
    Dim intXcount As Integer
    Dim intYcount As Integer
    Dim lngLocx As Long
    Dim lngLocy As Long

    'get the handle to the mappoint window and it's DC
    lngHwnd = GetMapWindowHandle(objmap.Application.Caption)
    lngDC = GetWindowDC(lngHwnd)
    
    'activate mappoint and select the requested route segment
    objmap.Application.Activate
    objmap.ActiveRoute.Directions(intSegment).Select
    objmap.ActiveRoute.Directions(intSegment).Location.GoTo
    objmap.Altitude = objmap.Altitude * 2
    'wait for the map to be redrawn
    wait 100
    
    'get the height and width of the map rounded to an even number
    'I don't now why but the code didn't work if I used odd numbers for
    'height and/or width
    lngWidth = ((objmap.Width) \ 2) * 2
    lngHeight = ((objmap.Height) \ 2) * 2
    
    'copy the map to the memory
    GetBitmap lngDC, 0, objmap.Application.Left + objmap.Left, objmap.Application.Top + objmap.Top, lngWidth, lngHeight
    
    'look for the label with the instruction
    blfound = False
    intGrid = 1
    Do
        'intGrid will count 1,2,4,8
        'intGridcount will then count 1; 3,2,1; 7,6,5,4,3,2,1 etc
        'by only taking the odd numbers, first the map is scanned in the middle
        'then on 1/4 and 3/4 then on 1/8, 3/8, 5/8 and 7/8 etc.
        'this is done until the label is found
        intGrid = intGrid * 2
        For intGridCount = intGrid - 1 To 1 Step -1
            If (intGridCount / 2) <> (intGridCount \ 2) Then
                Debug.Print intGridCount,
                intXcount = objmap.Width * ((1 / intGrid) * intGridCount)
                For intYcount = 1 To objmap.Height - 16
                    If CheckPixel(lngWidth, CLng(intXcount), CLng(intYcount), lngLocx, lngLocy) Then
                        'blfound = True
                        Exit For
                    End If
                    'If intYcount Mod 25 = 0 Then
                        'SetPixel lngDC, objMap.Left + intXcount, objMap.Top + intYcount, vbRed
                    'End If
                Next
                If blfound Then
                    Exit For
                End If
            End If
        Next
        Debug.Print
    Loop Until blfound Or intGrid = 64
    If lngLocx > 0 Then
        Set GetRouteSegmentStartLocation = objmap.XYToLocation(lngLocx, lngLocy)
    Else
        Set GetRouteSegmentStartLocation = Nothing
    End If
End Function

Function GetMapWindowHandle(strCaption As String) As Long
    'AppActivate appMap.Caption, False
      
    Dim sWindowText As String
    Dim hWndStart As Long
    Dim lngHwnd As Long
    Dim r As Integer
    ' Hold the level of recursion:
    Static level As Integer
    ' Hold the number of matching windows:
    Static iFound As Integer
    
    ' Initialize if necessary:
    hWndStart = GetDesktopWindow()
    
    ' Get first child window:
    lngHwnd = GetWindow(hWndStart, 5)
    
    Do Until lngHwnd = 0
    
       ' Get the window text
       sWindowText = Space(255)
       r = GetWindowText(lngHwnd, sWindowText, 255)
       sWindowText = Left(sWindowText, r)
       ' Check that window matches the search parameters:
      If sWindowText = strCaption Then
          GetMapWindowHandle = lngHwnd
          Exit Function
      End If
    
     ' Get next child window:
     lngHwnd = GetWindow(lngHwnd, 2)
    Loop

End Function

Sub wait(intHSec As Integer)
    Dim lngNow As Long
    lngNow = CLng(Timer * 100)
    Do While CLng(Timer * 100) < lngNow + intHSec
        DoEvents
        If CLng(Timer * 100) < lngNow Then 'after midnight
            wait intHSec
            Exit Do
        End If
    Loop
End Sub

Sub GetBitmap(lngHDCMap As Long, lngHDCForm As Long, x As Long, y As Long, lngWidht As Long, lngHeight As Long)
    'KPD-Team 2000
    'URL: http://www.allapi.net/
    'E-Mail: KPDTeam@Allapi.net
    '-> Compile this code for better performance
    
    Dim iBitmap As Long
    Dim iDC As Long
    Dim bi24BitInfo As BITMAPINFO
    'Dim lngStart As Long
    With bi24BitInfo.bmiHeader
        .biBitCount = 24
        .biCompression = BI_RGB
        .biPlanes = 1
        .biSize = Len(bi24BitInfo.bmiHeader)
        .biWidth = lngWidht
        .biHeight = lngHeight
    End With
    ReDim bBytes(1 To bi24BitInfo.bmiHeader.biWidth * bi24BitInfo.bmiHeader.biHeight * 3) As Byte
    iDC = CreateCompatibleDC(0)
    iBitmap = CreateDIBSection(iDC, bi24BitInfo, DIB_RGB_COLORS, ByVal 0&, ByVal 0&, ByVal 0&)
    SelectObject iDC, iBitmap
    BitBlt iDC, 0, 0, bi24BitInfo.bmiHeader.biWidth, bi24BitInfo.bmiHeader.biHeight, GetDC(0), x, y, vbSrcCopy
    GetBitmapBits iBitmap, UBound(bBytes), bBytes(1)

    DeleteDC iDC
    DeleteObject iBitmap
End Sub

Function CheckPixel(lngWidht As Long, lngXtest As Long, lngYtest As Long, lngXloc As Long, lngYloc As Long) As Boolean
    Dim intXcount As Integer
    
    If GetColor(lngWidht, lngXtest, lngYtest) = vbBlack Then
        If GetColor(lngWidht, lngXtest, lngYtest + 1) = vbWhite Then
            If GetColor(lngWidht, lngXtest, lngYtest + 14) = vbWhite Then
                If GetColor(lngWidht, lngXtest, lngYtest + 15) = vbBlack Then
                    Do
                        intXcount = intXcount - 1
                    Loop Until GetColor(lngWidht, lngXtest + intXcount, lngYtest + 1) = vbBlack
                    lngXloc = lngXtest + intXcount - 4
                    lngYloc = lngYtest - 4
                    CheckPixel = True
                End If
            End If
        End If
    End If
End Function

Function GetColor(lngWidht As Long, lngX As Long, lngY As Long) As Long
    Dim lngStart As Long
    lngStart = ((((((lngY - 1)) * lngWidht) + (lngX)) - 1) * 3) + 1
    GetColor = RGB(bBytes(lngStart + 2), bBytes(lngStart + 1), bBytes(lngStart))
End Function
